<?php

use App\Http\Controllers\Admin\BlogCategoryController;
use App\Http\Controllers\Admin\BlogController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Admin\WordpressController as AdminWordpressController;
use App\Http\Controllers\Admin\ContactUsController as AdminContactUsController;
use App\Http\Controllers\Admin\PageController as AdminPageController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\PackagesController as AdminPackagesController;
use App\Http\Controllers\Admin\BlogCommentController as AdminBlogCommentController;

use App\Http\Controllers\Auth\AdminAuthController;
use App\Http\Controllers\Auth\UserAuthController;



use App\Http\Controllers\Home\DigitalMarketingController;
use App\Http\Controllers\Home\WordpressController;
use App\Http\Controllers\Home\OrderController;
use App\Http\Controllers\Home\ContactUsController;
use App\Http\Controllers\Home\BlogController as FrontBlogController;
use App\Http\Controllers\Home\BlogLikeCommentController;
use App\Http\Controllers\Home\PageController;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => 'admin'], function () {
    Route::post('/register', [AdminAuthController::class, 'register']);
    Route::post('/login', [AdminAuthController::class, 'login']);
});

Route::group(['prefix' => 'admin', 'middleware' => ['assign.guard:admins', 'jwt.auth']], function () {
    Route::get('/blogCategories', [BlogCategoryController::class, "index"]);
    Route::get('/blogCategory/{id}', [BlogCategoryController::class, "show"]);
    Route::post('/create-blogCategory', [BlogCategoryController::class, "store"]);
    Route::post('/update-blogCategory', [BlogCategoryController::class, "update"]);
    Route::post('/delete-blogCategory', [BlogCategoryController::class, "destroy"]);
    Route::post('/manage-blogCategorySpecification', [BlogCategoryController::class, "manageLocaleSpecification"]);
    Route::post('/blogCategorySpecifications', [BlogCategoryController::class, "getLocaleSpecification"]);
    Route::get('/allBlogCategory', [BlogCategoryController::class, 'allBlogCategories']);


    Route::get('/blogs', [BlogController::class, "index"]);
    Route::get('/blog/{id}', [BlogController::class, "show"]);
    Route::post('/create-blog', [BlogController::class, "store"]);
    Route::post('/update-blog', [BlogController::class, "update"]);
    Route::post('/delete-blog', [BlogController::class, "destroy"]);
    Route::post('/manage-blogSpecification', [BlogController::class, "manageLocaleSpecification"]);
    Route::post('/blogSpecifications', [BlogController::class, "getLocaleSpecification"]);

    Route::get('/contacts', [AdminContactUsController::class, "index"]);
    Route::get('/contact/{id}', [AdminContactUsController::class, "show"]);
    Route::post('/delete-contact', [AdminContactUsController::class, "destroy"]);

    Route::get('/pages', [AdminPageController::class, "index"]);
    Route::get('/page/{page}', [AdminPageController::class, "show"]);
    Route::post('/update-page', [AdminPageController::class, "update"]);

    Route::get('/packages', [AdminPackagesController::class, "index"]);
    Route::get('/package/{id}', [AdminPackagesController::class, "details"]);
    Route::post('/update-package', [AdminPackagesController::class, "update"]);

    Route::get('/blog-comments', [AdminBlogCommentController::class, "index"]);
    Route::get('/comments/{id}', [AdminBlogCommentController::class, "blogComments"]);
    Route::post('/manage-comment', [AdminBlogCommentController::class, "manage"]);

});


Route::group(['prefix' => 'user'], function () {
    Route::post('/register', [UserAuthController::class, 'register']);
    Route::post('/login', [UserAuthController::class, 'login']);
});

Route::group(['prefix' => 'user', 'middleware' => ['assign.guard:users', 'jwt.auth']], function () {
});

Route::post('/wordpress-services', [WordpressController::class, 'getServices']);
Route::post('/wordpress-packages', [WordpressController::class, 'getPackages']);

Route::post('/digital-marketing-packages', [DigitalMarketingController::class, 'getPackages']);
Route::post('/digital-marketing-services', [DigitalMarketingController::class, 'getServices']);

Route::post('/contact-us', [ContactUsController::class, 'create']);
Route::post('/send-sms', [ContactUsController::class, 'prepareSms']);

Route::post('/order', [OrderController::class, 'create']);

Route::post('/create-service', [AdminWordpressController::class, 'createService']);
Route::post('/create-package', [AdminWordpressController::class, 'createPackage']);
Route::post('/add-package-item', [AdminWordpressController::class, 'addPackageItem']);

Route::get('blogs/categories', [FrontBlogController::class, 'blogCategory']);
Route::get('blogCategory', [FrontBlogController::class, 'blogCategoryName']);
Route::get('blogs/{category_url_name}', [FrontBlogController::class, 'allBlogsOfCategory']);
Route::get('blogs/{category_url_name}/{blog_url}', [FrontBlogController::class, 'showBlog']);
Route::get('allBlogList', [FrontBlogController::class, 'allBlogs']);
Route::get('homeBlogList', [FrontBlogController::class, 'homeBlogs']);
Route::get('category-info/{category_url_name}', [FrontBlogController::class, 'getCategoryInfo']);
Route::get('latest-blogs/{category_url_name}', [FrontBlogController::class, 'latestBlog']);
Route::get('page/{page}', [PageController::class, 'show']);
Route::post('blog-likes', [BlogLikeCommentController::class, 'getLikes']);
Route::post('like-blog', [BlogLikeCommentController::class, 'likeBlog']);
Route::post('blog-comments', [BlogLikeCommentController::class, 'getComments']);
Route::post('comment-blog', [BlogLikeCommentController::class, 'commentBlog']);

Route::post('blogEditorImages', [BlogController::class, 'blogEditorImages']);


Route::get('/clear-cache', function () {

    $exitCode = Artisan::call('optimize');
    $exitCode = Artisan::call('migrate');
    $exitCode1 = Artisan::call('config:cache');
    return 'DONE'; //Return anything
});

Route::get('/generate-sitemap', function () {

    $exitCode = Artisan::call('sitemap:create-sitemap');
    return 'DONE'; //Return anything
});
