<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blog_specifications', function (Blueprint $table) {
            $table->id();
            $table->string("locale");
            $table->string("title");
            $table->text('description');
            $table->string('keywords');
            $table->string('author');
            $table->text('index_description');
            $table->unsignedBigInteger('blog');
            $table->foreign('blog')->references('id')->on('blogs')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blog_specifications');
    }
};
