<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    use HasFactory;
    protected $fillable = ['name', 'url_name', 'keywords', 'author', 'index_description', 'parent','description','seo_title','og_title','og_description', 'og_image', 'og_type','meta_description'];

    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }

    public function child()
    {
        return $this->hasMany(BlogCategory::class,'parent', 'id');
    }

    public function specifications($locale)
    {
        return $this->hasMany(BlogCategorySpecification::class,"blogCategory","id")->where("locale",$locale);
    }
}
