<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;

    protected $fillable = ['title', 'description', 'keywords', 'author', 'url','special',
                            'index_image', 'index_image_alt', 'index_description','seo_title','og_title','og_description', 'og_image', 'og_type','meta_description'];


    public function blogCategory()
    {
        return $this->BelongsTo(BlogCategory::class, 'id', 'blogCategory_id');
    }

    public function specifications($locale)
    {
        return $this->hasMany(BlogSpecification::class,"blog","id")->where("locale",$locale);
    }

}
