<?php

namespace App\Http\Resources\Page;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class PageResource extends JsonResource
{

    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new PageCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $locale = $request->query("locale", "fa");

        return $this->filterFields([
            'id' => $this->id,
            'page' => $this->page,
            'keywords' => $this->keywords,
            'seo_title' => $this->seo_title,
            'meta_description' => $this->meta_description,
            'og_title' => $this->og_title,
            'og_description' => $this->og_description,
            'og_image' => URL::to("/") . $this->og_image,
            'og_type' => $this->og_type,
            'description' => $this->description,
            'index_description' => $this->index_description,
            'updated_at' => date($this->updated_at),
            'created_at' => date($this->created_at),
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
