<?php

namespace App\Http\Resources\ContactUs;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class ContactUsResource extends JsonResource
{

    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new ContactUsCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $fullname = $this->fullname;
        $email = $this->email;
        $phone = $this->phone;
        $message = $this->message;

        return $this->filterFields([
            'id' => $this->id,
            'fullname' => $fullname,
            'email' => $email,
            'phone' => $phone,
            'message' => $message,
            'updated_at' => date($this->updated_at),
            'created_at' => date($this->created_at),
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
