<?php

namespace App\Http\Resources\Comment;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Facades\URL;

class CommentCollection extends ResourceCollection
{
    protected $withoutFields = [];
    public $locale = "fa";


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {
        $this->locale = $request->query("locale", "fa");

        return $this->collection->map(function ($item) {

            return $this->filterFields([
                'id' => $item->id,
                'fullname' => $item->fullname,
                'email' => $item->email,
                'message' => $item->message,
                'updated_at' => date($item->updated_at),
                'created_at' => date($item->created_at),
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
