<?php

namespace App\Http\Resources\Blog;

use App\Models\BlogCategory;
use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class BlogResource extends JsonResource
{

    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new BlogCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        $locale = $request->query("locale", "fa");

        //$specifications = $this->specifications($locale)->get();

        $title = $this->title;
        $description = $this->description;
        $keywords = $this->keywords;
        $index_description = $this->index_description;
        $author = $this->author;
        // if (count($specifications) > 0) {
        //     $title = $specifications[0]['title'];
        //     $description = $specifications[0]['description'];
        //     // $keywords = $specifications[0]['keywords'];
        //     $index_description = $specifications[0]['index_description'];
        //     $author = $specifications[0]['author'];
        // }

        return $this->filterFields([
            'id' => $this->id,
            'title' => $title,
            'description' => $description,
            'index_image' => URL::to('/') . $this->index_image,
            'index_image_alt' => $this->index_image_alt,
            'author' => $author,
            'keywords' => $keywords,
            'url' => $this->url,
            'index_description' => $index_description,
            'seo_title' => $this->seo_title,
            'meta_description' => $this->meta_description,
            'og_title' => $this->og_title,
            'og_description' => $this->og_description,
            'og_image' => URL::to("/") . $this->og_image,
            'og_type' => $this->og_type,
            'og_url' => $this->url,
            'special' => $this->special,
            'blogCategory' => BlogCategory::whereId($this->blog_category_id)->first(),
            'updated_at' => date($this->updated_at),
            'created_at' => date($this->created_at)
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
