<?php

namespace App\Http\Resources\Blog;

use App\Helpers\ResponseData;
use App\Models\Blog;
use App\Models\BlogCategory;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Facades\URL;

class BlogCollection extends ResourceCollection
{
    protected $withoutFields = [];
    public $locale = "fa";


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {
        $this->locale = $request->query("locale", "fa");

        return $this->collection->map(function ($item){

            $title = $item->title;
            $description = $item->description;
            $keywords = $item->keywords;
            $index_description = $item->index_description;
            $author = $item->author;

            // $specifications = $item->specifications($this->locale)->get();

            // if (count($specifications) > 0) {
            //     $title = $specifications[0]['title'];
            //     $description = $specifications[0]['description'];
            //     $keywords = $specifications[0]['keywords'];
            //     $index_description = $specifications[0]['index_description'];
            //     $author = $specifications[0]['author'];
            // }

            return $this->filterFields([
                'id' => $item->id,
                'title' => $title,
                'description' => $description,
                'index_image' => URL::to("/"). $item->index_image,
                'index_image_alt' => $item->index_image_alt,
                'author' => $author,
                'keywords' => $keywords,
                'url' => $item->url,
                'index_description' => $index_description,
                'seo_title' => $item->seo_title,
                'meta_description' => $item->meta_description,
                'og_title' => $item->og_title,
                'og_description' => $item->og_description,
                'og_image' => URL::to("/"). $item->og_image,
                'og_type' => $item->og_type,
                'og_url' => $item->url,
                'special' => $item->special,
                'blogCategory' => BlogCategory::whereId($item->blog_category_id)->first(),
                'updated_at' => date($item->updated_at),
                'created_at' => date($item->created_at),
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
