<?php

namespace App\Http\Resources\Blog;

use App\Models\BlogCategory;
use App\Models\BlogCategorySpecification;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

use function Symfony\Component\String\Slugger\getLocale;

class BlogCategoryResource extends JsonResource
{


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $parent = $this->parent == 0 ? '-' : BlogCategory::whereId($this->parent)->pluck('name');
        $locale = $request->query("locale", "fa");

        $specifications = $this->specifications($locale)->get();
        $name = $this->name;
        if (count($specifications) > 0) {
            $name = $specifications[0]['name'];
        }

        return [
            'id' => $this->id,
            'name' => $name,
            'url_name' => $this->url_name,
            'parent' => $parent,
            'author' => $this->author,
            'keywords' => $this->keywords,
            'index_description' => $this->index_description,
            'description' => $this->description,
            'hasChild' => $this->child->count(),
            'seo_title' => $this->seo_title,
            'meta_description' => $this->meta_description,
            'og_title' => $this->og_title,
            'og_description' => $this->og_description,
            'og_image' => URL::to("/") . $this->og_image,
            'og_type' => $this->og_type,
            'og_url' => $this->url,
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran')),
            'updated_at' => date(verta($this->updated_at)->timezone('Asia/Tehran')),
            'specification' => BlogCategorySpecification::where('blogCategory', '=', $this->id)->get()
        ];
    }
}
