<?php

namespace App\Http\Controllers\Home;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Packages\PackagesResource;
use App\Http\Resources\Service\ServiceResource;
use App\Models\Package;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class WordpressController extends Controller
{
    public function getServices(Request $req)
    {
        Artisan::call('optimize');
        $category = $req->category;

        $services = Service::where('service', 'wordpress')->where('category', $category)->get();
        return ServiceResource::collection($services);
    }

    public function getPackages(Request $req)
    {
        $category = $req->category;

        $packages = Package::where('service', 'wordpress')->where('category', $category)->orderBy('order')->get();
        return PackagesResource::collection($packages);
    }
}
