<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Http\Resources\Packages\PackagesResource;
use App\Http\Resources\Service\ServiceResource;
use App\Models\Package;
use App\Models\Service;
use Illuminate\Http\Request;

class DigitalMarketingController extends Controller
{
    public function getPackages(Request $req)
    {
        $category = $req->category;

        $packages = Package::where('service', 'digital_marketing')->where('category', $category)->orderBy('order')->get();
        return PackagesResource::collection($packages);
    }

    public function getServices(Request $req)
    {
        $category = $req->category;

        $services = Service::where('service', 'digital_marketing')->where('category', $category)->get();
        return ServiceResource::collection($services);
    }
}
