<?php

namespace App\Http\Controllers\Home;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Comment\CommentResource;
use App\Models\BlogComment;
use App\Models\BlogLike;
use Illuminate\Http\Request;

class BlogLikeCommentController extends Controller
{
    public function getLikes(Request $req)
    {
        $likes = BlogLike::where('blog_id', $req->id)->count();
        return ResponseData::success('Likes', $likes);
    }

    public function likeBlog(Request $req)
    {
        $check = BlogLike::where('blog_id', $req->id)->where('browser', $req->user_id)->first();
        if (!$check) {
            BlogLike::create([
                'browser' => $req->user_id,
                'blog_id' => $req->id
            ]);
        }
        $likes = BlogLike::where('blog_id', $req->id)->count();
        return ResponseData::success('Likes', $likes);
    }

    public function getComments(Request $req)
    {
        $comments = BlogComment::where('blog_id', $req->id)->where('active', 1)->get();
        return CommentResource::collection($comments);
    }

    public function commentBlog(Request $req)
    {
        BlogComment::create([
            'fullname' => $req->fullname,
            'email' => $req->email,
            'message' => $req->message,
            'blog_id' => $req->id,
            'active'=> 0
        ]);
        $comments = BlogComment::where('blog_id', $req->id)->where('active',1)->get();
        return CommentResource::collection($comments);
    }
}
