<?php

namespace App\Http\Controllers\Home;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Blog\BlogCategoryResource;
use App\Http\Resources\Blog\BlogResource;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\BlogLike;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function blogCategory(Request $request)
    {
        $parent = $request->parent;
        $categories = BlogCategory::whereParent($parent)->get();
        return BlogCategoryResource::collection($categories);
    }


    public function blogCategoryName(Request $request)
    {
        $url_name = $request->url_name;
        $category = BlogCategory::where('url_name', '=', $url_name)->first();

        $locale = $request->query("locale", "fa");
        $specifications = $category->specifications($locale)->get();

        $name = $category->name;
        if (count($specifications) > 0) {
            $name = $specifications[0]['name'];
        }
        return [
            'name' => $name,
            'keywords' => $category->keywords,
            'author' => $category->author,
            'index_description' => $category->index_description,
            'url' => $category->url_name
        ];
    }

    public function allBlogsOfCategory(Request $request)
    {

        $category = BlogCategory::where('url_name', '=', $request->category_url_name)->first();
        $child_categories = $category->child()->pluck('id');

        $blogs = Blog::query();

        $blogs = $blogs->where('blog_category_id', $category->id)->orWhereIn('blog_category_id', $child_categories);

        if ($keyword = request('search')) {

            $blogs->where(function ($q) use ($keyword) {
                $q->where('title', 'LIKE', "%{$keyword}%")
                    ->orWhere('description', 'LIKE', "%{$keyword}%");
            });
        }

        $blogs = $blogs->orderByDesc('created_at')->paginate(12);
        return BlogResource::collection($blogs);
    }

    public function allBlog()
    {
        $blogs = Blog::orderByDesc('special')->orderByDesc('created_at')->get();
        return BlogResource::collection($blogs);
    }

    public function showBlog(Request $request)
    {
        $blog_url = $request->blog_url;
        $blog = Blog::whereUrl($blog_url)->first();
        return ResponseData::success('', new BlogResource($blog));
    }

    public function allBlogs(Request $request)
    {
        return BlogResource::collection(Blog::orderByDesc('special')->orderByDesc('created_at')->paginate(9));
    }

    public function homeBlogs(Request $request)
    {
        return BlogResource::collection(Blog::orderByDesc('special')->orderByDesc('created_at')->paginate(4));
    }

    public function getCategoryInfo(Request $req)
    {
        $category = BlogCategory::where('url_name', '=', $req->category_url_name)->first();
        return ResponseData::success("", new BlogCategoryResource($category));
    }

    public function latestBlog(Request $req)
    {
        $blogs = Blog::orderByDesc('created_at')->limit(5)->get();
        if ($req->category_url_name != "all") {
            $category = BlogCategory::where('url_name', '=', $req->category_url_name)->first();

            $blogsOfCategory = Blog::where('blog_category_id', $category->id)->orderByDesc('created_at')->limit(5)->get();
        } else {
            $blogsOfCategory = $blogs;
        }


        return ResponseData::success('Latest Blogs', [
            'category' => BlogResource::collection($blogsOfCategory),
            'all' => BlogResource::collection($blogs)
        ]);
    }
}
