<?php

namespace App\Http\Controllers\Auth;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserAuthController extends Controller
{
    public function register(Request $req)
    {
        $email = $req->email;
        $password = bcrypt($req->password);
        $name = $req->name;
        $mobile = $req->mobile;

        $user = User::create([
            'email' => $email,
            'password' => $password,
            'name' => $name,
            'mobile' => $mobile
        ]);

        $token = auth()->guard('users')->login($user);
        return $this->respondWithToken($token);
    }

    public function login(Request $request)
    {

        // $resoponse= Http::asForm()->post('https://www.google.com/recaptcha/api/siteverify',[
        //     'secret'=> '6Leb5VciAAAAALkjKTGRw333XnNG30dbqbjs0D9H',
        //     'response'=> $request->recaptcha_token,
        //     'remoteip'=> $request->ip()
        // ]);
        // if($resoponse['success'] != true){
        //     return ResponseData::error('خطا در اعتبارسنجی Recaptcha');
        // }

        $credentials = $request->only(['email', 'password']);

        $user = User::where('email', $request->email)->orWhere('mobile', $request->email)->first();

        if (!$user) {
            return ResponseData::error("نام کاربری  یا رمز عبور نادرست است", null, 403);
        }
        $credentials['email'] = $user->email;
        if (!$token = auth()->guard('users')->attempt($credentials)) {
            return ResponseData::error("نام کاربری   یا رمز عبور نادرست است", null, 403);
        }

        return $this->respondWithToken($token);
    }

    public function changePassword(Request $req)
    {
        $user = User::where('id', auth()->guard('users')->user()->id)->first();
        if (Hash::check($req->current_password, $user->password)) {
            $user->password = bcrypt($req->new_password);
            $user->save();
            return ResponseData::success('رمز عبور با موفقیت تغییر یافت');
        } else {
            return ResponseData::error('رمز عبور فعلی نادرست است');
        }
    }

    protected function respondWithToken($token)
    {
        $data = [
            'access_token' => $token,
            'token_type' => 'bearer',
            'user' => auth()->guard('users')->user(),
            'g2fa' => 0,
            'expires_in' => auth()->guard('users')->factory()->getTTL() * 60
        ];
        return ResponseData::success('خوش آمدید', $data);
    }
}
