<?php

namespace App\Http\Controllers\Auth;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Admin\AdminResource;
use App\Models\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AdminAuthController extends Controller
{
    public function register(Request $req)
    {
        $email = $req->email;
        $mobile = $req->mobile;
        $name = $req->name;
        $password = bcrypt($req->password);
        $admin = Admin::create([
            'email' => $email,
            'mobile' => $mobile,
            'name' => $name,
            'password' => $password
        ]);

        $token = auth()->guard('admins')->login($admin);
        return $this->respondWithToken($token);
    }

    public function login(Request $request)
    {

        $credentials = $request->only(['email', 'password']);
        $user = Admin::where('email', $request->email)->orWhere('mobile', $request->email)->first();

        if (!$user) {
            return ResponseData::error("نام کاربری  یا رمز عبور نادرست است", null, 403);
        }
        $credentials['email'] = $user->email;
        if (!$token = auth()->guard('admins')->attempt($credentials)) {
            return ResponseData::error("نام کاربری  یا رمز عبور نادرست است", null, 403);
        }

        return $this->respondWithToken($token);
    }

    protected function respondWithToken($token)
    {
        $data = [
            'access_token' => $token,
            'token_type' => 'bearer',
            'user' => new AdminResource(auth()->guard('admins')->user()),
            'g2fa' => 0,
            'expires_in' => auth()->guard('admins')->factory()->getTTL() * 60
        ];
        return ResponseData::success('خوش آمدید', $data);
    }

    public function changePassword(Request $req)
    {
        $user = Admin::where('id', auth()->guard('admins')->user()->id)->first();
        if (Hash::check($req->current_password, $user->password)) {
            $user->password = bcrypt($req->new_password);
            $user->save();
            return ResponseData::success('رمز عبور با موفقیت تغییر یافت');
        } else {
            return ResponseData::error('رمز عبور فعلی نادرست است');
        }
    }
}
