<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\PackageItem;
use App\Models\Service;
use Illuminate\Http\Request;

class WordpressController extends Controller
{
    public function createService(Request $req)
    {
        $service= $req->service;
        $category= $req->category;
        $title= $req->title;

        $service= Service::create([
            'service'=> $service,
            'title'=> $title,
            'category'=> $category
        ]);
        return ResponseData::success('با موفقیت اضافه شد', $service);
    }

    public function createPackage(Request $req)
    {
        $service= $req->service;
        $category= $req->category;
        $title= $req->title;
        $price= $req->price;
        $order= $req->order;

        $package= Package::create([
            'service'=> $service,
            'category'=> $category,
            'title'=> $title,
            'price'=> $price,
            'order'=> $order
        ]);
        return ResponseData::success('با موفقیت اضافه شد', $package);
    }

    public function addPackageItem(Request $req)
    {
        $package= $req->id;
        $title= $req->title;

        $item= PackageItem::create([
            'package_id'=> $package,
            'title'=> $title
        ]);
        return ResponseData::success('با موفقیت اضافه شد', $item);
    }
}
