<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Page\PageResource;
use App\Models\PageSeo;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class PageController extends Controller
{

    public function index()
    {
        $pages = PageSeo::query();

        if ($keyword = request('search')) {
            $pages->where('seo_title', 'LIKE', "%{$keyword}%")
                ->orWhere('meta_description', 'LIKE', "%{$keyword}%")
                ->orWhere('keywords', 'LIKE', "%{$keyword}%");
        }

        $pages = $pages->orderByDesc('id')->paginate(20);
        return PageResource::collection($pages);
    }

    public function show($page)
    {
        $blog = PageSeo::where('page', $page)->first();
        return ResponseData::success('', new PageResource($blog));
    }

    public function update(Request $request)
    {
        $page = PageSeo::where('page', $request->page)->first();
        $validData = $request->validate([
            'keywords' => ['required', 'string', Rule::unique('page_seos')->ignore($page->id)],
            'seo_title' => ['string', 'required'],
            'meta_description' => ['string', 'required'],
            'og_title' => ['string', 'required'],
            'og_description' => ['string', 'required'],
            'og_type' => ['string', 'required'],
            'description' => ['string', 'required'],
            'index_description' => ['string', 'required'],
        ]);

        $page->update($validData);


        if ($request->hasFile('og_image')) {
            $og_image = $request->file('og_image');
            $og_filename = time() . '_' . $og_image->getClientOriginalName();
            $og_image->move(public_path('blogs'), $og_filename);
            $og_photo_path = '/blogs/' . $og_filename;
            $page->og_image = $og_photo_path;
            $page->update();
        }

        return ResponseData::success("نوشته  با موفقیت ویرایش شد", new PageResource($page));
    }
}
