<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Packages\PackagesResource;
use App\Models\Package;
use Illuminate\Http\Request;

class PackagesController extends Controller
{
    public function index()
    {
        $packages = Package::query()->where('service','!=',"wordpress");
        if(request()->query("search",null) != null) {
            $q= request()->query("search");
            $packages = $packages->where("category","LIKE","%".$q."%");
        }
        return PackagesResource::collection($packages->paginate(20));
    }

    public function details($id)
    {
        $package = Package::findOrFail($id);
        return ResponseData::success('data', PackagesResource::make($package));
    }

    public function update(Request $request)
    {
        $package = Package::findOrFail($request->id);
        $package->price = $request->price;
        $package->save();
        return ResponseData::success('data', PackagesResource::make($package));
    }
}
