<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\ContactUs\ContactUsResource;
use App\Models\ContactUs;
use Illuminate\Http\Request;

class ContactUsController extends Controller
{
    public function index()
    {
        $contacts = ContactUs::query();

        if ($keyword = request('search')) {
            $contacts->where('fullname', 'LIKE', "%{$keyword}%")
                ->orWhere('email', 'LIKE', "%{$keyword}%")
                ->orWhere('phone', 'LIKE', "%{$keyword}%");
        }
        $contacts = $contacts->orderByDesc('id')->paginate(20);
        return ContactUsResource::collection($contacts);
    }

    /**
     * Display the specified resource.
     *
     * @param ContactUs $contact
     */
    public function show($id)
    {
        $contact = ContactUs::where('id', $id)->first();
        return ResponseData::success('', new ContactUsResource($contact));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param ContactUs $contact
     */
    public function destroy(Request $request)
    {
        $contact = ContactUs::where('id', $request->id)->first();
        $contact->delete();
        return ResponseData::success("Success");
    }
}
