<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Blog\BlogResource;
use App\Http\Resources\Comment\CommentResource;
use App\Models\BlogComment;
use Faker\Core\Blood;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BlogCommentController extends Controller
{
    public function index()
    {
        $blogs = DB::select("SELECT blogs.* from blogs JOIN blog_comments
             ON blogs.id= blog_comments.blog_id WHERE
            blog_comments.active= 0");
        return ResponseData::success('data',$blogs);
    }

    public function blogComments($id)
    {
        $comments = BlogComment::where('blog_id', $id)->paginate(20);
        return CommentResource::collection($comments);
    }

    public function manage(Request $request)
    {
        $comment = BlogComment::find($request->id);

        if ($request->action == "1") {
            $comment->active = 1;
            $comment->save();
        } else {
            BlogComment::where("id", $request->id)->delete();
        }
        return ResponseData::success("Done");
    }
}
