<?php

namespace App\Console\Commands;

use App\Models\ScheduleLog;
use Illuminate\Console\Command;
use Spatie\Sitemap\Tags\Url;

class Sitemap extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sitemap:create-sitemap';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Daily sitemap creation';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        ScheduleLog::create([
            'command' => $this->signature,
            'payload' => $this->description
        ]);

        $sitemap = \Spatie\Sitemap\Sitemap::create()
            ->add('https://softwares.land/rules');

        $blogCategories = \App\Models\BlogCategory::all();
        foreach ($blogCategories as $blogCategory) {
            $sitemap->add("https://softwares.land/blogs/{$blogCategory->url_name}");
        }

        $blogs = \App\Models\Blog::all();
        foreach ($blogs as $blog) {
            $blogCategory = \App\Models\BlogCategory::whereId($blog->blog_category_id)->first();
            $sitemap->add("https://softwares.land/blogs/{$blogCategory->url_name}/{$blog->url}");
        }

        $sitemap->writeToFile(public_path('sitemap.xml'));
        return 0;
    }


}
